﻿


CREATE PROCEDURE [App].[NVCC_usp_GetLabs]
	-- Add the parameters for the stored procedure here
	@pid bigint   --this is the patientSID
AS
--=================================================================================
--Requestor				: Non Va Coordinated Care Project
--Author                : Jerry Kohler (Original script by Dr. Charles Demosthenes)
--Object/SP Name		: NVCC_usp_GetLabs
--Server				: 
--Data Base				: CC_REFDOC
--Schema				: app
--Report				: N/A
--Folder				: N/A
--Report Loc            : N/A
--Job                   : None
--Job Loc               : None
--Note                  : 
--Date Created          : 01-06-2016
--
--Last Changed          : 02-18-2016  
--Last Changed By		: Jerry Kohler - Northwest Innovation Center (NWIC)
--Reason For Change		: Request to also provide the name of the station.
--
--Changed               : 02-16-2016  
--Changed By		    : Jerry Kohler - Northwest Innovation Center (NWIC)
--Reason For Change		: We only want the most recent value for any of the
--                        labs.
--
--Changed               : 01-12-2016  
--Changed By		    : Jerry Kohler - Northwest Innovation Center (NWIC)
--Reason For Change		: Removed station parameter in order to expand the search
--                        for a patient's labs from a single station to any
--                        station a patient is associated with by acquiring all
--                        PatientSIDs from the passed SIDs ICN.
--
--Changed               : 01-11-2016  
--Changed By		    : Jerry Kohler - Northwest Innovation Center (NWIC)
--Reason For Change		: Integrated into the NWIC lab process whereby lab test
--                        names are determined by combinations of LOINC or workload
--                        codes, and not relying on the facilities to normalize or
--                        standardize their lab test names.
--
--Purpose               : Retrieve results for certain lab tests within the last 15
--                        months and pass that data back to the NVCC application.
--=================================================================================
BEGIN
   -- SET NOCOUNT ON added to prevent extra result sets from
   -- interfering with SELECT statements.
   SET NOCOUNT ON;

   WITH LabsLast15Months AS
   (
   SELECT lab.Sta3n
         ,lab.LabChemSID
         ,tst.LabChemTestName
         ,tst.LabChemPrintTestName
         ,lab.LabChemSpecimenDateTime
         ,lab.LabChemResultValue
         ,iif(lab.Units    is null,' ',lab.Units) as units
         ,iif(lab.Abnormal is null,' ',lab.Abnormal) as abnormal
         ,iif(lab.RefHigh  is null,' ',lab.RefHigh) as RefHigh
         ,iif(lab.RefLow   is null,' ',lab.RefLow) as RefLow
         ,lab.LabChemResultNumericValue
         ,lab.LabChemTestSID
         ,lab.PatientSID
         ,ROW_NUMBER() over (partition by tst.LabChemTestName order by lab.LabChemSpecimenDateTime DESC) AS RowNum
   FROM  CDWWork.Chem.LabChem AS lab
   INNER JOIN CDWWork.Dim.LabChemTest AS tst ON lab.LabChemTestSID = tst.LabChemTestSID
   --INNER JOIN CDWWork.SPatient.SPatient s on s.PatientSID=lab.PatientSID
   WHERE lab.PatientSID IN (Select PtSID from App.udf_AllPatientsSIDs(@pid)) AND
      lab.LabChemTestSID IN (Select r.LabChemTestSID
                                  From [PanelMgmt].[PMMasterLabIndex] r
                                 Where r.TestGroup IN (Select Distinct s.TestGroup
                                                         From [PanelMgmt].[PMMasterCohortLabTestGroups] s
                                                         Join [PanelMgmt].[PMMasterLabTestGroupsCohort] t
                                                           On t.TestGroup = s.TestGroup
                                                        Where t.Cohort = 'NVCC')
                               ) --Patient SID 2440025 is a good test case
     AND lab.LabChemCompleteDateTime >= DATEADD(month, -15, GETDATE())
	 --AND s.DateOfDeath is NULL
   )

   SELECT Sta3n
         ,App.udf_StationName (Sta3n) AS StationName
         ,LabChemSID
         ,LabChemTestName
         ,LabChemPrintTestName
         ,LabChemSpecimenDateTime
         ,LabChemResultValue
         ,units
         ,abnormal
         ,RefHigh
         ,RefLow
         ,LabChemResultNumericValue
         ,LabChemTestSID
         ,PatientSID
		-- into App.LabsLast15Months
   FROM  LabsLast15Months
   WHERE RowNum = 1

END



